
class GooBlob extends Effects;

#exec TEXTURE IMPORT NAME=GooBlob FILE=Textures\GooBlob.bmp group="Skins" LODSET=2

var() texture BlobTypes[5];

simulated function Setup(vector WallNormal)
{
	Texture = BlobTypes[int(Frand()*5)];
	Velocity = VRand()*140*FRand()+WallNormal*250;
	DrawScale = FRand()*0.3 + 0.2;
}

auto state Explode
{

	simulated function Landed( vector HitNormal )
	{
		Destroy();
	}

	simulated function HitWall( vector HitNormal, actor Wall )
	{
		Destroy();
	}
}

defaultproperties
{
     BlobTypes(0)=Texture'GooBlob'
     BlobTypes(1)=Texture'GooBlob'
     BlobTypes(2)=Texture'GooBlob'
     BlobTypes(3)=Texture'GooBlob'
     BlobTypes(4)=Texture'GooBlob'
     bHighDetail=True
     Physics=PHYS_Falling
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=7.000000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'GooBlob'
     bUnlit=True
     CollisionRadius=4.000000
     CollisionHeight=4.000000
     bCollideWorld=True
     bBounce=True
     NetPriority=2.000000
}
